<?php defined('SYSPATH') or die('No direct script access.');

class Task_Filler_Logpost extends Minion_Task{
    protected function _execute(array $params){
	    $limit = 10000;
	    $counter = Helper::getCounter('fill_log');
	    $fields = ['id', 'client_id', 'data', 'host', 'post', 'referrer', 'length', 'datetime', 'link', 'logkeys'];

	    $model = DB::select()
		    ->from('logpost')
		    ->where('id', '>', $counter)
		    ->limit($limit)
		    ->order_by('id')
		    ->execute('default')
	        ->as_array();

	    if(!empty($model)) {
		    $logpost = DB::insert('logpost', $fields);
		    foreach ($model as $t) {
			    $t['client_id'] = $t['test_id'];
			    unset($t['test_id']);
			    $logpost->values(Arr::extract($t, $fields));
		    }

		    try{
			    $logpost->execute();
		    }catch (Exception $e){
			    Minion_CLI::write(substr($e, 0, 500));
			    exit;
		    }

	    }

	    $last = end($model);
	    Helper::updCounter($last['id'], 'fill_log');
    }
}